<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DirectedSession extends Model 
{

    protected $table = 'directed_sessions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'status');

    public function freelanceDirectedSession()
    {
        return $this->hasMany('App\Models\DirectedSession');
    }

}